/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.view;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import org.openoffice.accessibility.awb.view.ObjectView;
import org.openoffice.accessibility.awb.view.ObjectViewContainer;
import org.openoffice.accessibility.awb.view.ViewGridLayout;
import org.openoffice.accessibility.misc.NameProvider;

public class ContextView
extends ObjectView
implements ActionListener {
    private JLabel maNameLabel;
    private JLabel maDescriptionLabel;
    private JLabel maRoleLabel;

    public static ObjectView Create(ObjectViewContainer objectViewContainer, XAccessibleContext xAccessibleContext) {
        if (xAccessibleContext != null) {
            return new ContextView(objectViewContainer);
        }
        return null;
    }

    public ContextView(ObjectViewContainer objectViewContainer) {
        super(objectViewContainer);
        ViewGridLayout viewGridLayout = new ViewGridLayout(this);
        this.maNameLabel = viewGridLayout.AddLabeledString("Name:");
        this.maDescriptionLabel = viewGridLayout.AddLabeledString("Description:");
        this.maRoleLabel = viewGridLayout.AddLabeledEntry("Role:");
    }

    public void Update() {
        if (this.mxContext == null) {
            this.maNameLabel.setText("<null object>");
            this.maDescriptionLabel.setText("<null object>");
            this.maRoleLabel.setText("<null object>");
        } else {
            this.maNameLabel.setText(this.mxContext.getAccessibleName());
            this.maDescriptionLabel.setText(this.mxContext.getAccessibleDescription());
            this.maRoleLabel.setText(NameProvider.getRoleName(this.mxContext.getAccessibleRole()));
        }
    }

    public String GetTitle() {
        return "Context";
    }

    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        switch (accessibleEventObject.EventId) {
            case 1: 
            case 2: {
                this.Update();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }
}

